if (!([Security.Principal.WindowsPrincipal][Security.Principal.WindowsIdentity]::GetCurrent()).IsInRole([Security.Principal.WindowsBuiltInRole] "Administrator")) { Start-Process powershell.exe "-NoProfile -ExecutionPolicy Bypass -File `"$PSCommandPath`"" -Verb RunAs; exit }
function Import-certificates { 
    param(
        [Parameter(Mandatory=$true)]
        $path
    )
    $files = Get-ChildItem $path -Filter "*.crt"
    foreach($cert in $files){        
        $command = "& C:\Windows\System32\certutil.exe -addstore 'Root' " + ($path + "\" + $cert.name) 
        $command | Invoke-Expression | Out-Null
    }
}

$regkeys = @(@{})
$regkeys = @(
    @{keypath = "HKLM:\SOFTWARE\Microsoft\.NETFramework\v4.0.30319" ; keyname = "SchUseStrongCrypto" ; keyvalue = 1 ; keyproperty = "DWORD"}
    @{keypath = "HKLM:\SOFTWARE\Wow6432Node\Microsoft\.NETFramework\v4.0.30319" ; keyname = "SchUseStrongCrypto" ; keyvalue = 1 ; keyproperty = "DWORD"}
)

foreach($regkey in $regkeys) {
    if ((get-ItemProperty -Path $regkey.keypath -Name $regkey.keyname -ErrorAction SilentlyContinue) -eq $null) {
        new-ItemProperty -Path $regkey.keypath -name $regkey.keyname -Value $regkey.keyvalue -PropertyType $regkey.property
    } else {
        new-ItemProperty -Path $regkey.keypath -name $regkey.keyname -Value $regkey.keyvalue
    }
}

function confirmation {
    param(
        [Parameter(Mandatory=$true)]
        $message,
        [Parameter(Mandatory=$true)]
        $question
    )

    $choices = New-Object Collections.ObjectModel.Collection[Management.Automation.Host.ChoiceDescription] 
    $choices.Add((New-Object Management.Automation.Host.ChoiceDescription -ArgumentList '&Ja')) 
    $choices.Add((New-Object Management.Automation.Host.ChoiceDescription -ArgumentList '&Nee')) 
    $decision = $Host.UI.PromptForChoice($message, $question, $choices, 1)
    if ($decision -eq 0) {
        return $true
    } else {
        return $false
    }
}

if ((confirmation -message 'Installatie 14hosting.nl RootCertificaat' -question '14hosting.nl RootCertificaat installeren? Zonder dit certificaat geven diverse tools certificaat foutmeldingen.') -eq $true) {
    Set-Item wsman:\localhost\client\trustedhosts * -Force -Confirm:$false
    Import-certificates -path $PSScriptRoot
}

if ((confirmation -message 'Installatie RSAT tools' -question 'Remote Server Administrative tools (RSaT) installeren op deze machine?') -eq $true) {
    Write-Host "Bezig met het installeren van RSAT tools. Sluit dit venster niet af!"
    Get-WindowsCapability -name rsat* -Online | Add-WindowsCapability -Online | Out-Null
    Write-Host "Klaar met installatie." -ForegroundColor Green 
}

#if ((confirmation -message 'Installatie SQL management studio' -question 'SQL management studio installeren?') -eq $true) {
#    Write-Host "Installatie SQL management studio gestart."
#    $command = "& " + $PSScriptRoot + "\SSMS-Setup-ENU.exe /install /passive"
#    $command | Invoke-Expression
#}

if ((confirmation -message 'Installatie Forticlient VPN' -question 'Forticlient VPN installatie starten?') -eq $true) {
    Write-Host "Installatie Forticlient VPN gestart."
    $command = "& " + $PSScriptRoot + "\FortiClientVPNOnlineInstaller"
    $command | Invoke-Expression
}




